% This script reproduces the counts as shown in Figures 3-8. 
% It reads the Excel file Total number of mentions per subcategory.xlsx 

clear variables;close all;clc
[X,Xt]=xlsread('Total number of mentions per subcategory.xlsx','A2:BW147');

Racedrivers=[01, 04, 07, 19, 22, 23, 24, 25, 26, 27];
Engineers = [02, 03, 06, 08, 09, 10, 11, 12, 13, 14];
Instructors = [15, 16, 17, 18, 20, 21, 28, 29, 30, 31];
[Q,P]=deal(NaN(size(X,1),1));
for i=1:length(Xt)
    if cell2mat(strfind(Xt(i),'Q8'))>0
        Q(i)=8;
    end
    if cell2mat(strfind(Xt(i),'Q9'))>0
        Q(i)=9;
    end
    if cell2mat(strfind(Xt(i),'Q10'))>0
        Q(i)=10;
    end
    if cell2mat(strfind(Xt(i),'Q11'))>0
        Q(i)=11;
    end
    if cell2mat(strfind(Xt(i),'Q12'))>0
        Q(i)=12;
    end
    ppinchar=char(Xt(i));
    P(i)=str2double(ppinchar(3:5));
end

Figure3=[sum(sign(X(Q==8 & ismember(P,Racedrivers),1:20)))' sum(sign(X(Q==8 & ismember(P,Engineers),1:20)))' sum(sign(X(Q==8 & ismember(P,Instructors),1:20)))']; %Q8
Figure4=[sum(sign(X(Q==11 & ismember(P,Racedrivers),1:20)))' sum(sign(X(Q==11 & ismember(P,Engineers),1:20)))' sum(sign(X(Q==11 & ismember(P,Instructors),1:20)))']; %Q11
Figure5=[sum(sign(X(Q==8 & ismember(P,Racedrivers),40:55)))' sum(sign(X(Q==8 & ismember(P,Engineers),40:55)))' sum(sign(X(Q==8 & ismember(P,Instructors),40:55)))']; %Q8
Figure6=[sum(sign(X(Q==9 & ismember(P,Racedrivers),40:55)))' sum(sign(X(Q==9 & ismember(P,Engineers),40:55)))' sum(sign(X(Q==9 & ismember(P,Instructors),40:55)))']; %Q9
Figure7=[sum(sign(X(Q<=12 & ismember(P,Racedrivers),21:36)))' sum(sign(X(Q==12 & ismember(P,Engineers),21:36)))' sum(sign(X(Q==12 & ismember(P,Instructors),21:36)))']; %Q12
Figure8([1:6 8:16],:)=            [sum(sign(X(Q==10 & ismember(P,Racedrivers),56:70)))' sum(sign(X(Q==10 & ismember(P,Engineers),56:70)))' sum(sign(X(Q==10 & ismember(P,Instructors),56:70)))']; %Q10
Figure8([1 7],:)=Figure8([1 7],:)+[sum(sign(X(Q==10 & ismember(P,Racedrivers),[21 28])))' sum(sign(X(Q==10 & ismember(P,Engineers),[21 28])))' sum(sign(X(Q==10 & ismember(P,Instructors),[21 28])))']; %Q10 - in two cases, the response was also applicable to driving on public roads and classified as such. Add these to the total.

NFigure3= sum(sign([sum(sign(X(Q==8  & ismember(P,Racedrivers),1:20)),2)  sum(sign(X(Q==8  & ismember(P,Engineers),1:20)),2)  sum(sign(X(Q==8 & ismember(P,Instructors),1:20)),2)])); % Q8
NFigure4= sum(sign([sum(sign(X(Q==11 & ismember(P,Racedrivers),1:20)),2)  sum(sign(X(Q==11 & ismember(P,Engineers),1:20)),2)  sum(sign(X(Q==11 & ismember(P,Instructors),1:20)),2)])); % Q11
NFigure5= sum(sign([sum(sign(X(Q==8  & ismember(P,Racedrivers),40:55)),2) sum(sign(X(Q==8  & ismember(P,Engineers),40:55)),2) sum(sign(X(Q==8 & ismember(P,Instructors),40:55)),2)])); % Q8
NFigure6= sum(sign([sum(sign(X(Q==9  & ismember(P,Racedrivers),40:55)),2) sum(sign(X(Q==9  & ismember(P,Engineers),40:55)),2) sum(sign(X(Q==9 & ismember(P,Instructors),40:55)),2)])); % Q9
NFigure7=[sum(sign(sum(sign(X(Q==12 & ismember(P,Racedrivers([1:3 5:10])),21:36)),2)))+sum(sign(sum(sign(X(Q==8 & ismember(P,Racedrivers(4)),21:36)),2))) ...
          sum(sign(sum(sign(X(Q==12 & ismember(P,Engineers),21:36)),2))) sum(sign(sum(sign(X(Q==12 & ismember(P,Instructors),21:36)),2)))]; % 'Being experienced' for 1 race driver was listed as Q8 instead of Q12
NFigure8=[sum(sign(sum(sign(X(Q==10 & ismember(P,Racedrivers),56:70)),2))) sum(sign(sum(sign(X(Q==10 & ismember(P,Engineers),56:70)),2))) sum(sign(sum(sign(X(Q==10 & ismember(P,Instructors),56:70)),2)))];

disp('Figure 3')
disp(Figure3)

disp('Figure 4')
disp(Figure4)

disp('Figure 5')
disp(Figure5)

disp('Figure 6')
disp(Figure6)

disp('Figure 7')
disp(Figure7)

disp('Figure 8')
disp(Figure8)

disp('Sample sizes for Tables 3-8')
disp([NFigure3
 NFigure4
 NFigure5
 NFigure6
 NFigure7
 NFigure8]);

%%
VideoRatings=xlsread('Video-Ratings.xlsx','C4:L35');
VideoRatings([11 22],:)=[];


AllEnvironmentsMean=[mean(mean(VideoRatings(1:10,1:10),2)) mean(mean(VideoRatings(11:20,1:10),2)) mean(mean(VideoRatings(21:30,1:10),2))];
disp('All environments, Means:')
disp(round(AllEnvironmentsMean,2))

AllEnvironmentSD=[std(mean(VideoRatings(1:10,1:10),2)) std(mean(VideoRatings(11:20,1:10),2)) std(mean(VideoRatings(21:30,1:10),2))];
                           
disp('All environments, SDs:')
disp(round(AllEnvironmentSD,2))

EachEnvironmentSeparatelyMean=[mean(mean(VideoRatings(1:10,1:2),2)) mean(mean(VideoRatings(11:20,1:2),2)) mean(mean(VideoRatings(21:30,1:2),2)) 
                              mean(mean(VideoRatings(1:10,3:4),2))   mean(mean(VideoRatings(11:20,3:4),2))   mean(mean(VideoRatings(21:30,3:4),2))
                              mean(mean(VideoRatings(1:10,5:10),2))  mean(mean(VideoRatings(11:20,5:10),2))  mean(mean(VideoRatings(21:30,5:10),2))];
disp('Each environment separately, Means:')
disp(round(EachEnvironmentSeparatelyMean,2))

EachEnvironmentSeparatelySD=[std(mean(VideoRatings(1:10,1:2),2)) std(mean(VideoRatings(11:20,1:2),2)) std(mean(VideoRatings(21:30,1:2),2)) 
                              std(mean(VideoRatings(1:10,3:4),2))   std(mean(VideoRatings(11:20,3:4),2))   std(mean(VideoRatings(21:30,3:4),2))
                              std(mean(VideoRatings(1:10,5:10),2))  std(mean(VideoRatings(11:20,5:10),2))  std(mean(VideoRatings(21:30,5:10),2))];
disp('Each environment separately, SDs:')
disp(round(EachEnvironmentSeparatelySD,2))


EachVideoSeparatelyMean=[mean(VideoRatings(1:10,:))' mean(VideoRatings(11:20,:))' mean(VideoRatings(21:30,:))'];
disp('Each video separately, Means:')
disp(EachVideoSeparatelyMean)

EachVideoSeparatelySD=[std(VideoRatings(1:10,:))' std(VideoRatings(11:20,:))' std(VideoRatings(21:30,:))'];
disp('Each video separately, SDs:')
disp(round(EachVideoSeparatelySD,2))
